/* 
 * sigaction.c 
 *
 * Встановлює власний обробник для сигналу SIGINT, виводить запит до
 * користувача і протягом певного часу (TIMEOUT) чекає від нього
 * натиснення клмбінації клавіш Ctrl+C.
 * Ілюструє порядок організації асинхронної обробки сигналів
 * (функція sigaction()).
 *
 */

#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

volatile sig_atomic_t gotsig = -1;


/* Обробник сигналу SIGINT */
void sigint_handler(int signum)
{
        gotsig = signum;
}

int main()
{
        enum { TIMEOUT = 5 };
        struct sigaction act;
        time_t start, stop;

        /* Визначає нову диспозицію для сигналу SIGINT. */
        memset(&act, 0, sizeof(act));
        act.sa_handler = sigint_handler;
        if (sigaction(SIGINT, &act, NULL) != 0) {
                fprintf(stderr, "Помилка при спробі встановити диспозицію"
                                " сигналу SIGINT: %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }

        printf("Натисність комбінацію клавіш Ctrl+C протягом"
                                        " %ld секунд.\n", (long) TIMEOUT);
        start = time(NULL);
        if (start < 0) {
                fprintf(stderr, "Помилка при спробі отримати поточний час:"
                                                " %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }
        sleep(TIMEOUT);
        stop = time(NULL);
        if (stop < 0) {
                fprintf(stderr, "Помилка при спробі отримати поточний час:"
                                                " %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }
        printf("Чекання тривало %ld сек.\n", (long) (stop - start));

        if (gotsig > 0)
                /* Нижня половина обробника сигналу SIGINT */
                printf("Отримано сигнал із номером %ld.\n", (long) gotsig);
        else
                printf("Сигнал не було отримано.\n");

        exit(EXIT_SUCCESS);
}
